import { useEffect, useState } from 'react';

import { RightOutlined } from '@ant-design/icons';
import { Col, Row } from 'antd';
import Moment from 'moment';
import { useRouter } from 'next/router';

import Layout from '~/components/layout';

import api, { DetailsResp } from './api';
import styles from './index.module.scss';
import newsApi, { Item } from '../components/news/api';

export default function TenderProjectsDetail() {
  const router = useRouter();
  const [data, setData] = useState<DetailsResp>();
  const [newsList, setNewList] = useState<Item[]>([]);

  // 获取案例详情
  useEffect(() => {
    const id = Number(router.query.id);
    if (id) {
      api
        .details({
          id,
        })
        .then((res) => {
          setData(res.result || undefined);
        });
    }
  }, [router]);

  // 获取新闻列表
  useEffect(() => {
    newsApi
      .listNewsPage({
        pageNo: 1,
        pageSize: 10,
      })
      .then((res) => {
        setNewList(res.result?.list || []);
      });
  }, []);

  const fontColor = (i: number) => {
    switch (i) {
      case 0:
        return {
          color: '#ff2c46',
        };
      case 1:
        return {
          color: '#FF6602',
        };

      case 2:
        return {
          color: '#FAA910',
        };

      default:
        return {
          color: '#9295A3',
        };
    }
  };

  return (
    <Layout layoutStyle={{ backgroundColor: '#fff' }}>
      <div style={{ paddingTop: 29 }}>
        <Row justify='space-between' wrap={false}>
          <Col flex='auto'>
            <div className={styles.font1}>{data?.tenderTitle}</div>
            <div className={styles.font2} style={{ marginTop: 18, marginBottom: 41 }}>
              {data?.createTime && Moment(data?.createTime).format('YYYY-MM-DD')}
            </div>
            <div
              style={{ lineHeight: 1.5 }}
              className={styles.richText}
              dangerouslySetInnerHTML={{ __html: data?.tenderContent || '' }}
            ></div>
          </Col>
          <Col>
            <div className={styles.newsBox}>
              <Row
                className={styles.font4}
                align='middle'
                style={{ paddingTop: 16, paddingLeft: 20 }}
              >
                行业新闻
                <RightOutlined style={{ fontSize: 16, marginLeft: 9 }} />
              </Row>
              <Row gutter={10} style={{ marginTop: 8 }}>
                <Col span={24}>
                  {newsList.map((item, i) => {
                    return (
                      <Row
                        key={item.id}
                        justify='space-between'
                        align='middle'
                        style={{ cursor: 'pointer' }}
                        onClick={() => {
                          router.push(`/projectInfo/newsArticle/${item.id}`);
                        }}
                      >
                        <Col
                          className={`${styles.font3}`}
                          style={{ margin: '6px 23px 6px 19px', width: '100%' }}
                        >
                          <Row wrap={false}>
                            <Col span={2} style={{ textAlign: 'center', ...fontColor(i) }}>
                              {i + 1}
                            </Col>
                            <Col span={22} className={styles.ellipse1}>
                              {item.newsTitle}
                            </Col>
                          </Row>
                        </Col>
                      </Row>
                    );
                  })}
                </Col>
              </Row>
            </div>
          </Col>
        </Row>
      </div>
    </Layout>
  );
}
